/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.container.storage;

import java.util.Map;
import org.picocontainer.injectors.ProviderAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.rule.ActiveRules;
import org.sonar.api.batch.rule.Rule;
import org.sonar.api.batch.rule.Rules;
import org.sonar.api.batch.rule.internal.ActiveRulesBuilder;
import org.sonar.api.batch.rule.internal.NewActiveRule;
import org.sonar.api.resources.Languages;
import org.sonar.api.rule.RuleKey;
import org.sonarsource.sonarlint.core.client.api.connected.ConnectedAnalysisConfiguration;
import org.sonarsource.sonarlint.core.container.storage.ProtobufUtil;
import org.sonarsource.sonarlint.core.container.storage.StorageManager;
import org.sonarsource.sonarlint.core.proto.Sonarlint;

public class SonarQubeActiveRulesProvider
extends ProviderAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(SonarQubeActiveRulesProvider.class);
    private ActiveRules activeRules;

    public ActiveRules provide(Sonarlint.Rules storageRules, StorageManager storageManager, Rules rules, ConnectedAnalysisConfiguration analysisConfiguration, Languages languages) {
        if (this.activeRules == null) {
            Map<String, String> qProfilesByLanguage;
            ActiveRulesBuilder builder = new ActiveRulesBuilder();
            if (analysisConfiguration.moduleKey() == null) {
                LOG.debug("Use default quality profiles:");
                qProfilesByLanguage = storageRules.getDefaultQProfilesByLanguage();
            } else {
                LOG.debug("Quality profiles:");
                qProfilesByLanguage = storageManager.readModuleConfigFromStorage(analysisConfiguration.moduleKey()).getQprofilePerLanguage();
            }
            for (Map.Entry<String, String> entry : qProfilesByLanguage.entrySet()) {
                String language = entry.getKey();
                if (languages.get(language) == null) continue;
                String qProfileKey = entry.getValue();
                int arCount = 0;
                Sonarlint.ActiveRules activeRulesFromStorage = ProtobufUtil.readFile(storageManager.getActiveRulesPath(qProfileKey), Sonarlint.ActiveRules.parser());
                for (Map.Entry<String, Sonarlint.ActiveRules.ActiveRule> arEntry : activeRulesFromStorage.getActiveRulesByKey().entrySet()) {
                    Sonarlint.ActiveRules.ActiveRule activeRule = arEntry.getValue();
                    RuleKey ruleKey = RuleKey.of(activeRule.getRepo(), activeRule.getKey());
                    Rule rule = rules.find(ruleKey);
                    Sonarlint.Rules.Rule storageRule = storageRules.getRulesByKey().get(ruleKey.toString());
                    NewActiveRule newActiveRule = builder.create(ruleKey).setLanguage(language).setName(rule.name()).setInternalKey(rule.internalKey()).setTemplateRuleKey(storageRule.getTemplateKey()).setSeverity(activeRule.getSeverity());
                    for (Map.Entry<String, String> param : activeRule.getParams().entrySet()) {
                        newActiveRule.setParam(param.getKey(), param.getValue());
                    }
                    newActiveRule.activate();
                    ++arCount;
                }
                LOG.debug("  * " + language + ": " + qProfileKey + " (" + arCount + " rules)");
            }
            this.activeRules = builder.build();
        }
        return this.activeRules;
    }
}

